<?php

namespace App\Http\Controllers\Configuraciones;

use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Models\c_sucursale;

class DatosSucursalController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public static function getDireccionSucursal($sucursal){
        $datosSucursal = c_sucursale::where('sucursal', $sucursal)->first();

        $calle = $datosSucursal->direccion;
        $colonia = $datosSucursal->colonia;
        $municipio = $datosSucursal->municipio;
        $estado = $datosSucursal->estado;
        $cp = $datosSucursal->codigo_postal;

        //Concatenamos los datos para generar la direccion completa
        $direccion = $calle.' COL.'. $colonia.' '. $municipio.' '. $estado.' '. $cp;
        return $direccion;
    }

    public static function getDatosSucursal($sucursal)
    {
        $datosSucursal = DB::table('c_sucursales')
            ->join('c_empresas', 'c_sucursales.id_empresa', '=', 'c_empresas.id')
            ->select('c_empresas.empresa', 'c_sucursales.nombre', 'c_sucursales.telefono')
            ->where("c_sucursales.sucursal", "=", $sucursal)
            ->get();

        $direccion = DatosSucursalController::getDireccionSucursal($sucursal);

        $arrayDatos = array(
            'empresa' => $datosSucursal[0]->empresa,
            'nombre' => $datosSucursal[0]->nombre,
            'direccion' => $direccion,
            'telefono' => $datosSucursal[0]->telefono,
        );

        return json_encode($arrayDatos);
    }

    public static function getHorariosSucursal($sucursal)
    {
        $datosSucursal = DB::table('c_sucursales')
            ->join('c_boletos_extraviados', 'c_sucursales.id', '=', 'c_boletos_extraviados.id_sucursal')
            ->join('c_horario_sucursales', 'c_sucursales.id', '=', 'c_horario_sucursales.id_sucursal')
            ->select('apertura','cierre','costo')
            ->where("c_sucursales.sucursal", "=", $sucursal)
            ->get();

        $arrayDatos = array(
            'horario' => $datosSucursal[0]->apertura." A ".$horario=$datosSucursal[0]->cierre,
            'horario2' => $datosSucursal[1]->apertura." A ".$horario=$datosSucursal[1]->cierre,
            'costo' => $datosSucursal[0]->costo,
        );

        return json_encode($arrayDatos);
    }
}
