<?php

namespace App\Http\Controllers\Dashboard\Configuraciones\Permisos;

use Illuminate\Http\Request;
use Yajra\DataTables\DataTables;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use App\Http\Controllers\Controller;
use App\Models\c_categorias_permiso;
use App\Models\c_sub_categorias_permiso;
use Stevebauman\Location\Facades\Location;

class SubCategoriasController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function logRegistro($request, $status, $mensaje)
    {
        $arrayDatos = [
            'fecha/hora' => date('Y-m-d H:i:s'),
            'username' => session('nombreUsuarioSession'),
            'user_agent' => $request->header('User-Agent'),
            'url' => $request->fullUrl() . ' [' . $request->method() . ']',
            'location' => Location::get($request->ip()),
            'menseje' => $mensaje,
            'datos_subCategoria' => $request->all()
        ];

        if ($status == 'ok') {
            //Guardamos los datos en un archivo de log
            Log::withContext($arrayDatos)->info("Registro de sub-categoria de permisos del sistema exitosa");
        } else {
            //Guardamos los datos en un archivo de log
            Log::withContext($arrayDatos)->warning("Registro de sub-categoria de permisos del sistema fallida");
        }
    }

    public function logActualizacion($request, $status, $mensaje)
    {
        $arrayDatos = [
            'fecha/hora' => date('Y-m-d H:i:s'),
            'username' => session('nombreUsuarioSession'),
            'user_agent' => $request->header('User-Agent'),
            'url' => $request->fullUrl() . ' [' . $request->method() . ']',
            'location' => Location::get($request->ip()),
            'menseje' => $mensaje,
            'datos_subCategoria' => $request->all()
        ];

        if ($status == 'ok') {
            //Guardamos los datos en un archivo de log
            Log::withContext($arrayDatos)->info("Actualizacion de sub-categoria de permisos del sistema exitosa");
        } else {
            //Guardamos los datos en un archivo de log
            Log::withContext($arrayDatos)->warning("Actualizacion de sub-categoria de permisos del sistema fallida");
        }
    }

    public function logEliminacion($request, $status, $mensaje, $subCategoria)
    {
        $arrayDatos = [
            'fecha/hora' => date('Y-m-d H:i:s'),
            'username' => session('nombreUsuarioSession'),
            'user_agent' => $request->header('User-Agent'),
            'url' => $request->fullUrl() . ' [' . $request->method() . ']',
            'location' => Location::get($request->ip()),
            'menseje' => $mensaje,
            'datos_subCategoria' => $subCategoria
        ];

        if ($status == 'ok') {
            //Guardamos los datos en un archivo de log
            Log::withContext($arrayDatos)->info("Eliminacion de sub-categoria de permisos del sistema exitosa");
        } else {
            //Guardamos los datos en un archivo de log
            Log::withContext($arrayDatos)->warning("Eliminacion de sub-categoria de permisos del sistema fallida");
        }
    }

    public function show()
    {
        $categorias = c_categorias_permiso::where('activo', 1)->get();
        return view('dashboard.configuraciones.permisos.subCategorias', compact('categorias'));
    }

    public function subcategoriasData()
    {
        $data = DB::table('c_sub_categorias_permisos')
            ->join('c_categorias_permisos', 'c_categorias_permisos.id', '=', 'c_sub_categorias_permisos.id_categoria')
            ->select('c_sub_categorias_permisos.id', 'c_categorias_permisos.categoria', 'c_sub_categorias_permisos.sub_categoria', 'c_sub_categorias_permisos.activo')
            ->get();

        return DataTables::of($data)
            ->addColumn('action', function ($subCategoria) {
                return view('layouts.dashboard.partials.permisos.subcategorias.botones', compact('subCategoria'));
            })->make(true);
    }

    public function subcategoriaData($id_subcategoria)
    {
        //Se obtiene los datos de la subcategoria
        $subCategoriaData = c_sub_categorias_permiso::findOrFail($id_subcategoria);

        //Retorna los datos del rol y los permisos en formato json
        return Response()->json(["success" => true, 'data' => $subCategoriaData]);
    }

    public function registraSubcategoria(Request $request)
    {
        $idCategoria = $request->categoria;

        $validaNombreSubCategoria = c_sub_categorias_permiso::where('sub_categoria', $request->nombre_subcategoria)->where('id_categoria', $idCategoria)->count();

        if ($validaNombreSubCategoria >= 1) {
            $mensaje = 'El nombre de la sub-categoria ya se encuentra registrada';
            $this->logRegistro($request, 'error', $mensaje);
            notify()->error($mensaje, 'Registro de Subcategoria');
        } else {

            c_sub_categorias_permiso::create([
                'id_categoria' => $idCategoria,
                'sub_categoria' => strtoupper($request->nombre_subcategoria),
                'activo' => $request->estado
            ]);

            $mensaje = 'Sub-Categoria registrada correctamente';
            $this->logRegistro($request, 'ok', $mensaje);
            notify()->success($mensaje, 'Registro de Subcategoria');
        }

        return redirect()->route('configuraciones.permisos.subcategorias');
    }

    public function actulizaSubcategoria(Request $request)
    {
        $id_subcategoria = $request->id_subcategoria_edit; //Recuperamos el id de la subcategoria
        $idCategoria = $request->categoria_edit; //Recuperamos el id de la categoria
        $nombreSubCategoria = $request->nombre_subcategoria_edit; //Se obtiene el nombre de la subcategoria

        //Verifica si el nombre de la ya se encuentra registrado en la categoria
        $validaNombreSubCategoria = c_sub_categorias_permiso::where('sub_categoria', $nombreSubCategoria)->where('id_categoria', $idCategoria)->where('id', '!=', $id_subcategoria)->count();

        if ($validaNombreSubCategoria >= 1) {
            $mensaje = 'El nombre de la subcategoria ya se encuentra registrada';
            $this->logActualizacion($request, 'error', $mensaje);
            notify()->error($mensaje, 'Actualizacion de Subcategoria');
        } else {
            //Recuperamos la categoria a actualizar
            $subCategoria = c_sub_categorias_permiso::findOrFail($id_subcategoria);

            //Actualizamos los datos de la categoria
            $subCategoria->id_categoria = $idCategoria;
            $subCategoria->sub_categoria = strtoupper($nombreSubCategoria);
            $subCategoria->activo = $request->estado_edit;
            $subCategoria->update();

            $mensaje = 'Subcategoria actualizada correctamente';
            $this->logActualizacion($request, 'ok', $mensaje);
            notify()->success($mensaje, 'Actualizacion de Subcategoria');
        }

        return redirect()->route('configuraciones.permisos.subcategorias');
    }

    public function eliminaSubcategoria(Request $request)
    {
        $id =$request->id_subcategoria_destroy;
        $subCategoria = c_sub_categorias_permiso::findOrFail($id); //Recuperamos la subcategoria a eliminar

        //Valida si la subcategoria esta asociada a un permiso
        $validaSubCategoriaPermiso = DB::table('permissions')->where('id_sub_category', '=', $id)->count();

        if($validaSubCategoriaPermiso >= 1){
            $mensaje = 'La subcategoria no puede ser eliminada ya que esta asignada a un permiso';
            $this->logEliminacion($request, 'error', $mensaje, $subCategoria);
            notify()->error($mensaje, 'Eliminación de Subcategoria');
        }else{
            $subCategoria->delete();

            $mensaje = 'Subcategoria eliminada correctamente';
            $this->logEliminacion($request, 'ok', $mensaje, $subCategoria);
            notify()->success($mensaje, 'Eliminación de categoria');
        }

        return redirect()->route('configuraciones.permisos.subcategorias');
    }
}
