<?php

namespace App\Http\Controllers\Dashboard\Configuraciones;

use App\Models\User;
use App\Models\Sucursale;
use App\Models\c_sucursale;
use Illuminate\Http\Request;
use Yajra\DataTables\DataTables;
use Spatie\Permission\Models\Role;
use Illuminate\Support\Facades\Log;
use App\Http\Controllers\Controller;
use Stevebauman\Location\Facades\Location;

class UsuariosController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function logRegistro($request, $status, $user, $mensaje)
    {
        $arrayDatos = [
            'fecha/hora' => date('Y-m-d H:i:s'),
            'username' => session('nombreUsuarioSession'),
            'user_agent' => $request->header('User-Agent'),
            'url' => $request->fullUrl() . ' [' . $request->method() . ']',
            'location' => Location::get($request->ip()),
            'menseje' => $mensaje,
            'datos_usuario' => $user
        ];

        if ($status == 'ok') {
            //Guardamos los datos en un archivo de log
            Log::withContext($arrayDatos)->info("Registro de usuario exitoso [" . $user->username . "]");
        } else {
            //Guardamos los datos en un archivo de log
            Log::withContext($arrayDatos)->warning("Registro de usuario fallido [" . $user->username . "]");
        }
    }

    public function logActulizacion($request, $status, $user, $mensaje)
    {
        $arrayDatos = [
            'fecha/hora' => date('Y-m-d H:i:s'),
            'username' => session('nombreUsuarioSession'),
            'user_agent' => $request->header('User-Agent'),
            'url' => $request->fullUrl() . ' [' . $request->method() . ']',
            'location' => Location::get($request->ip()),
            'menseje' => $mensaje,
            'datos_usuario' => $user
        ];

        if ($status == 'ok') {
            //Guardamos los datos en un archivo de log
            Log::withContext($arrayDatos)->info("Actualizacion de datos del usuario exitoso [" . $user->username . "]");
        } else {
            //Guardamos los datos en un archivo de log
            Log::withContext($arrayDatos)->warning("Actualizacion de datos del usuario fallido [" . $user->username . "]");
        }
    }

    public function show()
    {
        //Obtenemos los roles registrados en el sistema
        $roles = Role::all();
        $listaSucursales = Sucursale::where('activa', 1)->get();

        //Retornamos la vista de la lista de usuarios junto los roles registrados en el sistema para mostrarlos en los modales de creación y edición de usuarios
        return view('dashboard.configuraciones.usuarios', compact('roles', 'listaSucursales'));
    }

    public function usuariosData()
    {
        $data = User::all();

        return DataTables::of($data)
            ->addColumn('action', function ($user) {
                return view('layouts.dashboard.partials.usuarios.botones', compact('user'));
            })->make(true);
    }

    public function registraUsuario(Request $request)
    {

        $validaUsuario = User::where('username', $request->usuario)->count();

        if ($validaUsuario >= 1) {
            $mensaje = 'El usuario ya se encuentra registrado';
            $this->logRegistro($request, 'error', $request->all(), $mensaje);
            notify()->error($mensaje, 'Registro de usuario');
        } else {
            //Obtenemos el nombre del rol
            $consultaNombreRol = Role::where('id', $request->rol)->get();
            $nombreRol = $consultaNombreRol->first()->name;

            $user = new User();
            $user->username = $request->usuario;
            $user->password = bcrypt($request->password);
            $user->nombre = strtoupper($request->nombre);
            $user->ap_paterno = strtoupper($request->ap_paterno);
            $user->ap_materno = strtoupper($request->ap_materno);
            $user->privilegio = $nombreRol;
            $user->sucursal_asignada = $request->sucursal;
            $user->activo = $request->get('estado') ? 1 : 0;

            $user->fecha_alta = date('Y-m-d');
            $user->assignRole($request->rol);
            $user->save();

            $mensaje = 'Usuario registrado correctamente';
            $this->logRegistro($request, 'ok', $user, $mensaje);
            notify()->success($mensaje, 'Registro de usuario');
        }

        return redirect()->route('configuraciones.usuarios');
    }

    public function usuarioData($id)
    {
        $usuarioData = User::findOrFail($id);
        return Response()->json(["success" => true, 'data' => $usuarioData]);
    }

    public function actulizaUsuario(Request $request)
    {
        //Recuperamos el usuario a actualizar
        $id = $request->id_edit;

        //Verificamos si se ha ingresado una contraseña nueva
        $password = $request->password_edit;

        //Verifica si el usuario ya esta registrado
        $validaUsuario = User::where('username', $request->usuario_edit)->where('id', '!=', $id)->count();

        if ($validaUsuario >= 1) {
            $mensaje = 'El usuario ya se encuentra registrado';
            $this->logActulizacion($request, 'error', $request->all(), $mensaje);
            notify()->error($mensaje, 'Actualizacion de usuario');
        } else {
            $usuario = User::findOrFail($id);
            $idRol = $request->rol_edit; //Almacenamos el id del rol

            //Obtenemos el nombre del rol
            $consultaNombreRol = Role::where('id', $idRol)->get();
            $nombreRol = $consultaNombreRol->first()->name;

            if ($password != '') $usuario->password = bcrypt($password);

            $usuario->username = $request->usuario_edit;
            $usuario->nombre = strtoupper($request->nombre_edit);
            $usuario->ap_paterno = strtoupper($request->ap_paterno_edit);
            $usuario->ap_materno = strtoupper($request->ap_materno_edit);
            $usuario->privilegio = $nombreRol;
            $usuario->sucursal_asignada = $request->sucursal_edit;
            $usuario->activo = $request->get('estado_edit') ? 1 : 0;

            $usuario->roles()->sync($idRol);
            $usuario->update();

            $mensaje = 'Usuario actulizado correctamente';
            $this->logActulizacion($request, 'ok', $usuario, $mensaje);
            notify()->success($mensaje, 'Actualizacion de usuario');
        }

        return redirect()->route('configuraciones.usuarios');
    }

    public function eliminaUsuario(Request $request)
    {
        $usuario = User::findOrFail($request->id_destroy);
        $usuario->delete();

        $mensaje = 'Usuario eliminado correctamente';
        $arrayDatos = [
            'fecha/hora' => date('Y-m-d H:i:s'),
            'username' => session('nombreUsuarioSession'),
            'user_agent' => $request->header('User-Agent'),
            'url' => $request->fullUrl() . ' [' . $request->method() . ']',
            'location' => Location::get($request->ip()),
            'menseje' => $mensaje,
            'datos_usuario' => $usuario
        ];
        Log::withContext($arrayDatos)->info("Usuario eliminado exitosamente [" . $usuario->username . "]");

        notify()->success($mensaje, 'Eliminacion de usuario');
        return redirect()->route('configuraciones.usuarios');
    }
}
