<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

class UserFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [

            'username' => 'admin',
            'password' => '$2y$10$JNnA/8iQRtW8yXleT6krdOl7a4nmelr7Aq4w6krZNoHG4CKkfiSQy',
            'nombre' => $this->faker->name,
            'ap_paterno' => $this->faker->lastName,
            'ap_materno' => $this->faker->lastName,
            'privilegio' => 'ADMINISTRADOR',
            'fecha_alta' => $this->faker->date(),
            'sucursal_asignada' => 'BDLAB11S',
            'activo' => '1',
        ];
    }

    /**
     * Indicate that the model's email address should be unverified.
     *
     * @return \Illuminate\Database\Eloquent\Factories\Factory
     */
    public function unverified()
    {
        return $this->state(function (array $attributes) {
            return [
                'email_verified_at' => null,
            ];
        });
    }
}
