<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class RoleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $roleAdminstrador = Role::create(['name' => 'ADMINISTRADOR']);
        $roleCajero = Role::create(['name' => 'CAJERO']);
        $roleGerente = Role::create(['name' => 'GERENTE']);
        $roleSupervisor = Role::create(['name' => 'SUPERVISOR']);
        $roleTesoreria = Role::create(['name' => 'TESORERIA']);
        $roleUsuario = Role::create(['name' => 'USUARIO']);



        // ************* DASHBOARD *************
        Permission::create([
            'name' => 'dashboard.inicio',
            'description' => 'Acceder al dashboard',
            'id_category' => '1',
            'id_sub_category' => '1'
        ])->syncRoles([$roleAdminstrador, $roleGerente, $roleSupervisor, $roleCajero]);
        //******************************************************************************* */

        // ************* CAJA *************
        Permission::create([
            'name' => 'caja.corte_caja',
            'description' => 'Acceder al corte de caja',
            'id_category' => '2',
            'id_sub_category' => '2'
        ])->syncRoles([$roleAdminstrador, $roleGerente, $roleSupervisor, $roleCajero]);

        Permission::create([
            'name' => 'caja.registra_ingreso',
            'description' => 'Realizar ingresos de caja',
            'id_category' => '2',
            'id_sub_category' => '2'
        ])->syncRoles([$roleAdminstrador, $roleCajero]);

        Permission::create([
            'name' => 'caja.registra_retiro',
            'description' => 'Realizar retiros a caja',
            'id_category' => '2',
            'id_sub_category' => '2'
        ])->syncRoles([$roleAdminstrador, $roleCajero]);

        Permission::create([
            'name' => 'caja.realiza_corte',
            'description' => 'Realizar corte de caja',
            'id_category' => '2',
            'id_sub_category' => '2'
        ])->syncRoles([$roleAdminstrador, $roleCajero]);

        Permission::create([
            'name' => 'caja.ultimos_movientos',
            'description' => 'Recuperar ultimos movimientos en caja',
            'id_category' => '2',
            'id_sub_category' => '2'
        ])->syncRoles([$roleAdminstrador, $roleCajero]);

        Permission::create([
            'name' => 'caja.ajuste_movimientos',
            'description' => 'Acceder al ajuste de movimientos de caja',
            'id_category' => '2',
            'id_sub_category' => '3'
        ])->syncRoles([$roleAdminstrador, $roleSupervisor]);

        Permission::create([
            'name' => 'caja.ajuste_movimientos.cancelar_ingresos',
            'description' => 'Cancelar los ingresos de caja',
            'id_category' => '2',
            'id_sub_category' => '3'
        ])->syncRoles([$roleAdminstrador, $roleSupervisor]);

        Permission::create([
            'name' => 'caja.ajuste_movimientos.cancelar_retiros',
            'description' => 'Cancelar los retiros de caja',
            'id_category' => '2',
            'id_sub_category' => '3'
        ])->syncRoles([$roleAdminstrador, $roleSupervisor]);


        Permission::create([
            'name' => 'caja.envio_cortes',
            'description' => 'Acceder al envio de cortes',
            'id_category' => '2',
            'id_sub_category' => '4'
        ])->syncRoles([$roleAdminstrador, $roleCajero]);

        //******************************************************************************* */


        // ************* TESORERIA *************
        Permission::create([
            'name' => 'tesoreria.recepcion_cortes',
            'description' => 'Acceder al recepción de cortes',
            'id_category' => '4',
            'id_sub_category' => '12'
        ])->syncRoles([$roleAdminstrador, $roleTesoreria]);

        Permission::create([
            'name' => 'tesoreria.revision_cortes',
            'description' => 'Acceder a la revisión de cortes',
            'id_category' => '4',
            'id_sub_category' => '14'
        ])->syncRoles([$roleAdminstrador, $roleTesoreria]);

        Permission::create([
            'name' => 'tesoreria.cierre_cortes',
            'description' => 'Acceder al cierre de cortes',
            'id_category' => '4',
            'id_sub_category' => '13'
        ])->syncRoles([$roleAdminstrador, $roleTesoreria]);
        //******************************************************************************* */


        // ************* CONFIGURACIONES *************
        Permission::create([
            'name' => 'configuraciones.usuarios',
            'description' => 'Acceder a los usuarios',
            'id_category' => '3',
            'id_sub_category' => '5'
        ])->syncRoles([$roleAdminstrador]);

        Permission::create([
            'name' => 'configuraciones.usuarios.registra_usuario',
            'description' => 'Registrar usuarios',
            'id_category' => '3',
            'id_sub_category' => '5'
        ])->syncRoles([$roleAdminstrador]);

        Permission::create([
            'name' => 'configuraciones.usuarios.actuliza_usuario',
            'description' => 'Actulizar usuarios',
            'id_category' => '3',
            'id_sub_category' => '5'
        ])->syncRoles([$roleAdminstrador]);

        Permission::create([
            'name' => 'configuraciones.usuarios.elimina_usuario',
            'description' => 'Eliminar usuarios',
            'id_category' => '3',
            'id_sub_category' => '5'
        ])->syncRoles([$roleAdminstrador]);
        //******************************************************************************* */


        Permission::create([
            'name' => 'configuraciones.roles',
            'description' => 'Acceder a los roles',
            'id_category' => '3',
            'id_sub_category' => '6'
        ])->syncRoles([$roleAdminstrador]);

        Permission::create([
            'name' => 'configuraciones.roles.registra_rol',
            'description' => 'Registrar roles',
            'id_category' => '3',
            'id_sub_category' => '6'
        ])->syncRoles([$roleAdminstrador]);

        Permission::create([
            'name' => 'configuraciones.roles.actuliza_rol',
            'description' => 'Actualizar roles',
            'id_category' => '3',
            'id_sub_category' => '6'
        ])->syncRoles([$roleAdminstrador]);

        Permission::create([
            'name' => 'configuraciones.roles.elimina_rol',
            'description' => 'Eliminar roles',
            'id_category' => '3',
            'id_sub_category' => '6'
        ])->syncRoles([$roleAdminstrador]);
        //******************************************************************************* */


        Permission::create([
            'name' => 'configuraciones.permisos',
            'description' => 'Acceder a los permisos',
            'id_category' => '3',
            'id_sub_category' => '7'
        ])->syncRoles([$roleAdminstrador]);

        Permission::create([
            'name' => 'configuraciones.permisos.registra_permiso',
            'description' => 'Registrar permisos',
            'id_category' => '3',
            'id_sub_category' => '7'
        ])->syncRoles([$roleAdminstrador]);

        Permission::create([
            'name' => 'configuraciones.permisos.actuliza_permiso',
            'description' => 'Actualizar permisos',
            'id_category' => '3',
            'id_sub_category' => '7'
        ])->syncRoles([$roleAdminstrador]);

        Permission::create([
            'name' => 'configuraciones.permisos.elimina_permiso',
            'description' => 'Eliminar permisos',
            'id_category' => '3',
            'id_sub_category' => '7'
        ])->syncRoles([$roleAdminstrador]);
        //******************************************************************************* */



        Permission::create([
            'name' => 'configuraciones.permisos.categorias',
            'description' => 'Acceder a las categorias de los permisos',
            'id_category' => '3',
            'id_sub_category' => '8'
        ])->syncRoles([$roleAdminstrador]);

        Permission::create([
            'name' => 'configuraciones.permisos.categorias.registra_categoria',
            'description' => 'Registrar categorias',
            'id_category' => '3',
            'id_sub_category' => '8'
        ])->syncRoles([$roleAdminstrador]);

        Permission::create([
            'name' => 'configuraciones.permisos.categorias.actuliza_categoria',
            'description' => 'Actualizar categorias',
            'id_category' => '3',
            'id_sub_category' => '8'
        ])->syncRoles([$roleAdminstrador]);

        Permission::create([
            'name' => 'configuraciones.permisos.categorias.elimina_categoria',
            'description' => 'Eliminar categorias',
            'id_category' => '3',
            'id_sub_category' => '8'
        ])->syncRoles([$roleAdminstrador]);
        //******************************************************************************* */




        Permission::create([
            'name' => 'configuraciones.permisos.subcategorias',
            'description' => 'Acceder a las subcategorias de los permisos',
            'id_category' => '3',
            'id_sub_category' => '9'
        ])->syncRoles([$roleAdminstrador]);

        Permission::create([
            'name' => 'configuraciones.permisos.subcategorias.registra_subcategoria',
            'description' => 'Registrar subcategorias',
            'id_category' => '3',
            'id_sub_category' => '9'
        ])->syncRoles([$roleAdminstrador]);

        Permission::create([
            'name' => 'configuraciones.permisos.subcategorias.actuliza_subcategoria',
            'description' => 'Actualizar subcategorias',
            'id_category' => '3',
            'id_sub_category' => '9'
        ])->syncRoles([$roleAdminstrador]);

        Permission::create([
            'name' => 'configuraciones.permisos.subcategorias.elimina_subcategoria',
            'description' => 'Eliminar subcategorias',
            'id_category' => '3',
            'id_sub_category' => '9'
        ])->syncRoles([$roleAdminstrador]);
        //******************************************************************************* */


        Permission::create([
            'name' => 'configuraciones.sucursales',
            'description' => 'Acceder al catalogo de sucursales',
            'id_category' => '3',
            'id_sub_category' => '10'
        ])->syncRoles([$roleAdminstrador]);

        Permission::create([
            'name' => 'configuraciones.sucursales.registra_sucursal',
            'description' => 'Registrar sucursales',
            'id_category' => '3',
            'id_sub_category' => '10'
        ])->syncRoles([$roleAdminstrador]);

        Permission::create([
            'name' => 'configuraciones.sucursales.actuliza_sucursal',
            'description' => 'Actualizar sucursales',
            'id_category' => '3',
            'id_sub_category' => '10'
        ])->syncRoles([$roleAdminstrador]);

        Permission::create([
            'name' => 'configuraciones.sucursales.elimina_sucursal',
            'description' => 'Eliminar sucursales',
            'id_category' => '3',
            'id_sub_category' => '10'
        ])->syncRoles([$roleAdminstrador]);
        //******************************************************************************* */


        Permission::create([
            'name' => 'configuraciones.terminales',
            'description' => 'Acceder al catalogo de terminales',
            'id_category' => '3',
            'id_sub_category' => '11'
        ])->syncRoles([$roleAdminstrador]);

        Permission::create([
            'name' => 'configuraciones.terminales.registra_terminal',
            'description' => 'Registrar terminales',
            'id_category' => '3',
            'id_sub_category' => '11'
        ])->syncRoles([$roleAdminstrador]);

        Permission::create([
            'name' => 'configuraciones.terminales.actuliza_terminal',
            'description' => 'Actualizar terminales',
            'id_category' => '3',
            'id_sub_category' => '11'
        ])->syncRoles([$roleAdminstrador]);

        Permission::create([
            'name' => 'configuraciones.terminales.elimina_terminal',
            'description' => 'Eliminar terminales',
            'id_category' => '3',
            'id_sub_category' => '11'
        ])->syncRoles([$roleAdminstrador]);

        Permission::create([
            'name' => 'configuraciones.terminales.descarga_key',
            'description' => 'Descargar llave de la terminal',
            'id_category' => '3',
            'id_sub_category' => '11'
        ])->syncRoles([$roleAdminstrador]);
        //******************************************************************************* */
    }
}
