$(document).ready(function() {
    $(function() {
        $('#choferes-table').DataTable({
            processing: true,
            serverSide: true,
            responsive: true,
            ajax: route('configuraciones.catalogos.choferes_data'),
            columns: [{
                    data: 'id',
                    name: 'id'
                },
                {
                    data: 'nom_comp',
                    name: 'nom_comp'
                },

                {
                    data: 'tipo_licencia',
                    name: 'tipo_licencia'
                },
                {
                    data: 'numero_licencia',
                    name: 'numero_licencia'
                },
                {
                    data: 'tipo_licencia_cla',
                    name: 'tipo_licencia_cla'
                },
                {
                    data: 'vigencia_licencia',
                    name: 'vigencia_licencia'
                },
                {
                    data: 'observaciones',
                    name: 'observaciones'
                },
                {
                    data: 'activo',
                    name: 'activo',
                    render: function(data, type, row) {
                        if (data == 1) {
                            return '<span class="badge badge-success">SI</span>';
                        } else {
                            return '<span class="badge badge-danger">NO</span>';
                        }
                    }
                },
                { data: 'action', name: 'action', orderable: false, searchable: false }
            ],
            "language": {
                "info": "_TOTAL_ Choferes",
                "search": "Buscar",
                "paginate": {
                    "next": "Siguiente",
                    "previous": "Anterior",
                },
                "lengthMenu": '_MENU_ Registros',
                "loadingRecords": "Cargando...",
                "processing": "Procesando...",
                "emptyTable": "SIN REGISTROS",
                "zeroRecords": "SIN REGISTROS",
                "infoEmpty": "",
                "infoFiltered": "",
            },
            fnDrawCallback: function(oSettings) {
                if (oSettings._iDisplayLength > oSettings.fnRecordsDisplay()) {
                    $(oSettings.nTableWrapper).find('.dataTables_paginate').hide();
                    $(oSettings.nTableWrapper).find('.dataTables_length').hide();
                }
            }
        });
    });
    const moonLanding = new Date();
    $("#form_registro").validate({
        debug: false,
        event: "blur",
        errorElement: "label",

        rules: {
            nombre: {
                required: true
            },
            appaterno: {
                required: true
            },
            apmaterno: {
                required: true
            },
            tipo_licencia: {
                required: true
            },
            num_licencia: {
                required: true
            },
            tipo_licencia_cla: {
                required: true
            },
            vigencia_licencia: {
                required: true,
                min: moonLanding.getFullYear()
            }
           
        },
        messages: {
            nombre: {
                required: "Favor de ingresar un nombre",
            },
            appaterno: {
                required: "Favor de ingresar un apellido paterno",
            },
            apmaterno: {
                required: "Favor de ingresar un apellido materno",
            },
            tipo_licencia: {
                required: "Favor de ingresar un tipo de licencia",
            },
            num_licencia: {
                required: "Favor de ingresar un número de licencia",
            },
            tipo_licencia_cla: {
                required: "Favor de ingresar la clave de licencia",
            },
            vigencia_licencia: {
                required: "Favor de ingresar la vigencia de la licencia",
                min: "La fecha tiene que ser mayor o igual al año actual",
            }
        },

        submitHandler: function(form, e) {
            e.preventDefault();
            //form.submit();
            
            const formularioData = new FormData(form);
            $("#registro_succes").prop('disabled', true);
            $.ajax({
                url: route('configuraciones.catalogos.choferes_guardar'),
                type: "POST",
                data: formularioData,
                contentType: false,
                processData: false,

                success: function (data) {
                    $("#btn_cerrar_notificacion").attr("onclick","reload_pag();");
                    let mensaje = data.mensaje;
                    modalSuccess(mensaje);
                },
                error: function (request, status) {
                    let mensaje = request.responseJSON.error;
                    let icon = request.responseJSON.icon;
                    modalError(mensaje, icon);
                    $("#registro_succes").prop('disabled', false);
                }

            });
            
        }
    });
});
function limpiaModal(){
    $('#nombre').val("");
    $('#appaterno').val("");
    $('#apmaterno').val("");
    $('#tipo_licencia').val("");
    $('#num_licencia').val("");
    $('#tipo_licencia_cla').val("");
    $('#vigencia_licencia').val("");
    $("#obser").val('');
    $('#Reg').val('');
    
    $('#registro_succes').html('Agregar'); $('#registro_succes').removeClass('btn-warning-fit-modal'); $('#registro_succes').addClass('btn-primary-fit-modal');

    $("#activo").prop("checked", true);
}
function editar(data){

    $('#nombre').val(data.nombre);
    $('#appaterno').val(data.ap_paterno);
    $('#apmaterno').val(data.ap_materno);
    $('#tipo_licencia').val(data.tipo_licencia);
    $('#num_licencia').val(data.numero_licencia);
    $('#tipo_licencia_cla').val(data.tipo_licencia_cla);
    $('#vigencia_licencia').val(data.vigencia_licencia);
    $("#obser").val(data.observaciones);
    $('#Reg').val(data.id);

    if(data.activo ==1) { $("#activo").prop("checked", true); } else if(data.activo ==0){ $("#activo").prop("checked", false); }
    $('#registro_succes').html('Editar'); $('#registro_succes').removeClass('btn-primary-fit-modal'); $('#registro_succes').addClass('btn-warning-fit-modal');
}
//Funcion que manda a llamar al modal que se le pase como paramentro
function toggleModal($modal) {
    var body = document.querySelector('body');
    var modal = document.querySelector('#' + $modal);
    modal.classList.toggle('opacity-0');
    modal.classList.toggle('pointer-events-none');
    body.classList.toggle('modal-active');
}

//Iniciar Modals de alerta
function modalError($mensaje, $icon) {
    $('#btn-aceptar').hide();
    $("#mensaje-notificacion").text("");
    $("#mensaje-notificacion").text($mensaje); //Mostramos el error
    $('#imagen-notificacion').attr('src', '../../../images/modal/'+$icon+'.png');
    toggleModal("notificacion");
}
function modalSuccess($mensaje) {
    $("#mensaje-notificacion").text("");
    $("#mensaje-notificacion").text($mensaje); //Mostramos el mensaje de exito
    $('#imagen-notificacion').attr('src', '../../../images/modal/success.png');
    toggleModal("notificacion"); //ocultamos el modal del registro
}
//reload function
function reload_pag(){
    window.location.reload();
}