$(document).ready(function() {
    $(function() {
        $('#tarifas-table').DataTable({
            processing: true,
            serverSide: true,
            responsive: true,
            ajax: route('configuraciones.catalogos.tarifas_data'),
            columns: [{
                    data: 'id_tarifa',
                    name: 'id_tarifa'
                },
                {
                    data: 'tarifa',
                    name: 'tarifa'
                },

                {
                    data: 'costo',
                    name: 'costo'
                },
                {
                    data: 'costo_valida',
                    name: 'costo_valida'
                },
                {
                    data: 'tiempo_fraccion',
                    name: 'tiempo_fraccion'
                },
                {
                    data: 'tiempo_hora',
                    name: 'tiempo_hora'
                },
                {
                    data: 'costo_aumento',
                    name: 'costo_aumento'
                },
                {
                    data: 'activo',
                    name: 'activo',
                    render: function(data, type, row) {
                        if (data == 1) {
                            return '<span class="badge badge-success">SI</span>';
                        } else {
                            return '<span class="badge badge-danger">NO</span>';
                        }
                    }
                },
                { data: 'action', name: 'action', orderable: false, searchable: false }
            ],
            "language": {
                "info": "_TOTAL_ Tarifas",
                "search": "Buscar",
                "paginate": {
                    "next": "Siguiente",
                    "previous": "Anterior",
                },
                "lengthMenu": '_MENU_ Tarifas',
                "loadingRecords": "Cargando...",
                "processing": "Procesando...",
                "emptyTable": "SIN REGISTROS",
                "zeroRecords": "SIN REGISTROS",
                "infoEmpty": "",
                "infoFiltered": "",
            },
            fnDrawCallback: function(oSettings) {
                if (oSettings._iDisplayLength > oSettings.fnRecordsDisplay()) {
                    $(oSettings.nTableWrapper).find('.dataTables_paginate').hide();
                    $(oSettings.nTableWrapper).find('.dataTables_length').hide();
                }
            }
        });
    });
    const moonLanding = new Date();
    $("#form_registro").validate({
        debug: false,
        event: "blur",
        errorElement: "label",

        rules: {
            tarifa: {
                required: true
            },
            costo: {
                required: true
            },
            costo_valida: {
                required: true
            },
            tiempo_fraccion: {
                required: true
            },
            tiempo_hora: {
                required: true
            },
            costo_aumento: {
                required: true
            }
           
        },
        messages: {
            tarifa: {
                required: "Favor de ingresar un concepto de tarifa",
            },
            costo: {
                required: "Favor de ingresar un costo",
            },
            costo_valida: {
                required: "Favor de ingresar un costo para el boleto validado",
            },
            tiempo_fraccion: {
                required: "Favor de ingresar un tiempo fracción",
            },
            tiempo_hora: {
                required: "Favor de ingresar un tiempo hora",
            },
            costo_aumento: {
                required: "Favor de ingresar un costo aumento",
            }
        },

        submitHandler: function(form, e) {
            e.preventDefault();
            //form.submit();
            
            const formularioData = new FormData(form);
            $("#registro_succes").prop('disabled', true);
            $.ajax({
                url: route('configuraciones.catalogos.tarifas_guardar'),
                type: "POST",
                data: formularioData,
                contentType: false,
                processData: false,

                success: function (data) {
                    $("#btn_cerrar_notificacion").attr("onclick","reload_pag();");
                    let mensaje = data.mensaje;
                    modalSuccess(mensaje);
                },
                error: function (request, status) {
                    let mensaje = request.responseJSON.error;
                    let icon = request.responseJSON.icon;
                    modalError(mensaje, icon);
                    $("#registro_succes").prop('disabled', false);
                }

            });
            
        }
    });
});
function limpiaModal(){
    $('#tarifa').val("");
    $('#costo').val("");
    $('#costo_valida').val("");
    $('#tiempo_fraccion').val("");
    $('#tiempo_hora').val("");
    $('#costo_aumento').val("");
    $('#Reg').val('');
    
    $('#registro_succes').html('Agregar'); $('#registro_succes').removeClass('btn-warning-fit-modal'); $('#registro_succes').addClass('btn-primary-fit-modal');

    $("#activo").prop("checked", true);
}
function editar(data){

    $('#tarifa').val(data.tarifa);
    $('#costo').val(data.costo);
    $('#costo_valida').val(data.costo_valida);
    $('#tiempo_fraccion').val(data.tiempo_fraccion);
    $('#tiempo_hora').val(data.tiempo_hora);
    $('#costo_aumento').val(data.costo_aumento);
    $('#Reg').val(data.id_tarifa);

    if(data.activo ==1) { $("#activo").prop("checked", true); } else if(data.activo ==0){ $("#activo").prop("checked", false); }
    $('#registro_succes').html('Editar'); $('#registro_succes').removeClass('btn-primary-fit-modal'); $('#registro_succes').addClass('btn-warning-fit-modal');
}
//Funcion que manda a llamar al modal que se le pase como paramentro
function toggleModal($modal) {
    var body = document.querySelector('body');
    var modal = document.querySelector('#' + $modal);
    modal.classList.toggle('opacity-0');
    modal.classList.toggle('pointer-events-none');
    body.classList.toggle('modal-active');
}

//Iniciar Modals de alerta
function modalError($mensaje, $icon) {
    $('#btn-aceptar').hide();
    $("#mensaje-notificacion").text("");
    $("#mensaje-notificacion").text($mensaje); //Mostramos el error
    $('#imagen-notificacion').attr('src', '../../../images/modal/'+$icon+'.png');
    toggleModal("notificacion");
}
function modalSuccess($mensaje) {
    $("#mensaje-notificacion").text("");
    $("#mensaje-notificacion").text($mensaje); //Mostramos el mensaje de exito
    $('#imagen-notificacion').attr('src', '../../../images/modal/success.png');
    toggleModal("notificacion"); //ocultamos el modal del registro
}
//reload function
function reload_pag(){
    window.location.reload();
}