$(document).ready(function() {
    $(function() {
        $('#roles-table').DataTable({
            processing: true,
            serverSide: true,
            responsive: true,
            ajax: route('configuraciones.roles.roles_data'),
            columns: [{
                    data: 'id',
                    name: 'id'
                },
                {
                    data: 'name',
                    name: 'name'
                },
                { data: 'action', name: 'action', orderable: false, searchable: false, width: '20%' }
            ],
            "language": {
                "info": "_TOTAL_ Roles",
                "search": "Buscar",
                "paginate": {
                    "next": "Siguiente",
                    "previous": "Anterior",
                },
                "lengthMenu": '_MENU_ Registros',
                "loadingRecords": "Cargando...",
                "processing": "Procesando...",
                "emptyTable": "SIN REGISTROS",
                "zeroRecords": "SIN REGISTROS",
                "infoEmpty": "",
                "infoFiltered": "",
            },
            fnDrawCallback: function(oSettings) {
                if (oSettings._iDisplayLength > oSettings.fnRecordsDisplay()) {
                    $(oSettings.nTableWrapper).find('.dataTables_paginate').hide();
                    $(oSettings.nTableWrapper).find('.dataTables_length').hide();
                }
            }
        });
    });

    $(function() {
        $.ajax({
            url: route('configuraciones.roles.permission_data'),
            contentType: false,
            processData: false,

            beforeSend: function() {
                //toggleModal("confirma-corte");
            },
            success: function(request) {
                permisosModalReg(request);
                permisosModalEdit(request);

                $(".ck_permiso2:checkbox:checked").removeAttr("checked");
            }

        });
    });

    function permisosModalReg(request) {
        request.data.forEach(function(data) {

            //Verificamos si el DIV de la categoria existe
            divCategoria = document.getElementById('div_cat' + data.id_category);

            //Verificamos si el DIV de subcategoria existe
            ulSubcategoria = document.getElementById('ul_sub_' + data.id_category + '_' + data.id_sub_category);




            if (divCategoria == null) {
                //Si no existe, creamos el DIV y la UL
                $('#div-permisos').append('' +
                    '<div id="div_cat' + data.id_category + '" class="mb-6">' +
                    '<h3 class="mb-2 text-base font-semibold text-gray-900">' + data.categoria + '</h3>' +
                    '</div>');

            }

            if (ulSubcategoria == null) {
                //Si no existe, creamos el DIV y la UL
                $('#div_cat' + data.id_category).append('' +
                    '<div id="div_sub_' + data.id_category + '_' + data.id_sub_category + '"  data-expanded="close" data-accordion="list_sub_' + data.id_category + '_' + data.id_sub_category + '" class="ml-6 mb-4 cursor-pointer accordion_permisos text-center flex items-center justify-start">' +
                    '<span class="mb-3 text-sm font-semibold text-gray-900">' + data.sub_categoria + '</span>' +

                    '<svg class="w-4 h-4 ml-1" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">' +
                    '<path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd"></path>' +
                    '</svg>' +
                    '</div>' +

                    '<div id="list_sub_' + data.id_category + '_' + data.id_sub_category + '" class="ml-6 mb-4 hidden">' +
                    /*'<h3 class="mb-3 text-sm font-semibold text-gray-900">' + data.sub_categoria + '</h3>' +*/
                    '<ul id="ul_sub_' + data.id_category + '_' + data.id_sub_category + '" class="items-center w-full text-sm font-medium text-gray-900 bg-white rounded-lg border border-gray-200">' +

                    '<li class="w-full border-b border-gray-200 sm:border-b-0 sm:border-r">' +
                    '<div class="flex items-center pl-4 ml-4">' +
                    '<input id="' + data.id + '" name="permisos[]" type="checkbox" value="' + data.id + '" class="w-4 h-4 text-blue-600 !important bg-gray-100 rounded border-gray-300 focus:ring-blue-500 !important">' +
                    '<label for="' + data.id + '" class="py-3 ml-2 w-full text-sm font-medium text-gray-900">' + data.description + '</label>' +
                    '</div>' +
                    '</li>' +
                    '</ul>' +

                    '</div>');
            } else {
                $('#ul_sub_' + data.id_category + '_' + data.id_sub_category).append('' +
                    '<li class="w-full border-b border-gray-200 sm:border-b-0 sm:border-r">' +
                    '<div class="flex items-center pl-4 ml-4">' +
                    '<input id="' + data.id + '" name="permisos[]" type="checkbox" value="' + data.id + '" class="w-4 h-4 class=ck_permiso2 text-blue-600 !important bg-gray-100 rounded border-gray-300 focus:ring-blue-500 !important">' +
                    '<label for="' + data.id + '" class="py-3 ml-2 w-full text-sm font-medium text-gray-900">' + data.description + '</label>' +
                    '</div>' +
                    '</li>');
            }
        });
    }

    function permisosModalEdit(request) {
        request.data.forEach(function(data) {

            //Verificamos si el DIV de la categoria existe
            divCategoria = document.getElementById('div_cat_edit' + data.id_category);

            //Verificamos si el DIV de subcategoria existe
            ulSubcategoria = document.getElementById('ul_sub_edit_' + data.id_category + '_' + data.id_sub_category);


            if (divCategoria == null) {
                //Si no existe, creamos el DIV y la UL
                $('#div-permisos-edit').append('' +
                    '<div id="div_cat_edit' + data.id_category + '" class="mb-6">' +
                    '<h3 class="mb-2 text-base font-semibold text-gray-900">' + data.categoria + '</h3>' +
                    '</div>');
            }

            if (ulSubcategoria == null) {
                //Si no existe, creamos el DIV y la UL
                $('#div_cat_edit' + data.id_category).append('' +
                    '<div id="div_sub_edit_' + data.id_category + '_' + data.id_sub_category + '" data-expanded="close" data-accordion="list_sub_edit_' + data.id_category + '_' + data.id_sub_category + '" class="ml-6 mb-4 cursor-pointer accordion_permisos text-center flex items-center justify-start">' +
                    '<span class="mb-3 text-sm font-semibold text-gray-900">' + data.sub_categoria + '</span>' +

                    '<svg class="w-4 h-4 ml-1" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">' +
                    '<path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd"></path>' +
                    '</svg>' +
                    '</div>' +

                    '<div id="list_sub_edit_' + data.id_category + '_' + data.id_sub_category + '" class="ml-6 mb-4 hidden overflow-hidden">' +
                    /*'<h3 class="mb-3 text-sm font-semibold text-gray-900">' + data.sub_categoria + '</h3>' +*/
                    '<ul id="ul_sub_edit_' + data.id_category + '_' + data.id_sub_category + '" class="items-center w-full text-sm font-medium text-gray-900 bg-white rounded-lg border border-gray-200">' +

                    '<li class="w-full border-b border-gray-200 sm:border-b-0 sm:border-r">' +
                    '<div class="flex items-center pl-4 ml-4">' +
                    '<input id="' + data.id + '" name="permisos_edit[]" type="checkbox" value="' + data.id + '" class="' + data.id + ' ck_permiso w-4 h-4 text-blue-600 bg-gray-100 rounded border-gray-300 focus:ring-blue-500">' +
                    '<label for="' + data.id + '" class="py-3 ml-2 w-full text-sm font-medium text-gray-900">' + data.description + '</label>' +
                    '</div>' +
                    '</li>' +
                    '</ul>' +

                    '</div>');
            } else {
                $('#ul_sub_edit_' + data.id_category + '_' + data.id_sub_category).append('' +
                    '<li class="w-full border-b border-gray-200 sm:border-b-0 sm:border-r">' +
                    '<div class="flex items-center pl-4 ml-4">' +
                    '<input id="' + data.id + '" name="permisos_edit[]" type="checkbox" value="' + data.id + '" class=" ' + data.id + ' ck_permiso w-4 h-4 text-blue-600 bg-gray-100 rounded border-gray-300 focus:ring-blue-500">' +
                    '<label for="' + data.id + '" class="py-3 ml-2 w-full text-sm font-medium text-gray-900">' + data.description + '</label>' +
                    '</div>' +
                    '</li>');
            }
        });
    }


    $("#form_agrega_rol").validate({
        debug: false,
        event: "blur",
        errorElement: "label",

        rules: {
            nombre_rol: {
                required: true,
                minlength: 3,
                maxlength: 45
            },
            'permisos[]': {
                required: true
            }
        },
        messages: {
            nombre_rol: {
                required: "Favor de ingresar un nombre para el rol",
                minlength: "El rol debe tener al menos 3 caracteres",
                maxlength: "El rol debe tener como máximo 45 caracteres"
            },

            'permisos[]': {
                required: "Favor de selecionar al menos un permiso"
            }
        },

        submitHandler: function(form, e) {
            e.preventDefault();
            form.submit();
            $("#btn-agrega-rol").prop('disabled', true);
        }
    });

    $("#form_actualizar_rol").validate({
        debug: false,
        event: "blur",
        errorElement: "label",

        rules: {
            nombre_rol_edit: {
                required: true,
                minlength: 3,
                maxlength: 45
            },
            'permisos_edit[]': {
                required: true
            }
        },
        messages: {
            nombre_rol_edit: {
                required: "Favor de ingresar un nombre para el rol",
                minlength: "El rol debe tener al menos 3 caracteres",
                maxlength: "El rol debe tener como máximo 45 caracteres"
            },

            'permisos_edit[]': {
                required: "Favor de selecionar al menos un permiso"
            }
        },

        submitHandler: function(form, e) {
            e.preventDefault();
            form.submit();
            $("#btn-actualiza-rol").prop('disabled', true);
        }
    });

    $("#form_elimina_rol").validate({
        debug: false,
        event: "blur",
        errorElement: "label",

        rules: {
            nombre_rol_edit: {
                required: true
            }
        },
        messages: {
            nombre_rol_edit: {
                required: "Favor de ingresar un nombre para el rol"
            }
        },

        submitHandler: function(form, e) {
            e.preventDefault();
            form.submit();
            $("#btn-elimina-rol").prop('disabled', true);
        }
    });

    $(document).on("click", ".btn-actuliza-rol", function() {
        //Se recupera la ruta del boton
        const urlControlador = $(this).data("controller");

        //Se ejecuta el controlador por medio de ajax
        $.ajax({
            url: urlControlador,
            contentType: false,
            processData: false,

            beforeSend: function() {
                $("#form_actualizar_rol")[0].reset();
                $(".ck_permiso:checkbox:checked").removeAttr("checked");
            },
            success: function(data) {
                $('#id_rol_edit').val(data.data.id);
                $("#nombre_rol_edit").val(data.data.name);

                //Recorrer el arreglo de permisos y marca los checkbox correspondientes
                data.permisos.forEach(function(data) {
                    $("." + data.permission_id + ":checkbox:not(:checked)").attr("checked", "checked");
                });
            }

        });
    });

    $(document).on("click", ".btn-elimina-rol", function() {
        //Se recupera la ruta del boton
        const urlControlador = $(this).data("controller");

        //Se ejecuta el controlador por medio de ajax
        $.ajax({
            url: urlControlador,
            contentType: false,
            processData: false,
            success: function(data) {
                $("#mensaje-notificacion").text("¿Desea eliminar el rol " + data.data.name + "?");
                $("#id_rol_destroy").val(data.data.id);
                $("#nombre_rol_destroy").val(data.data.name);
                toggleModal("confirma-elimina-rol");
            }
        });
    });

    function toggleModal($modal) {
        var body = document.querySelector('body');
        var modal = document.querySelector('#' + $modal);
        modal.classList.toggle('opacity-0');
        modal.classList.toggle('pointer-events-none');
        body.classList.toggle('modal-active');
    }
});
