$(document).ready(function () {
    $(function () {
        var table = $('#sucursales_table').DataTable({
            processing: true,
            serverSide: true,
            responsive: true,
            ajax: route('configuraciones.sucursales.sucursales_data'),
            columns: [{
                    data: 'id',
                    name: 'id'
                },
                {
                    data: 'sucursal',
                    name: 'sucursal'
                },
                {
                    data: 'nombre',
                    name: 'nombre'
                },
                {
                    data: 'tipo',
                    name: 'tipo'
                },
                {
                    data: 'activa',
                    name: 'activa',

                    render: function (data, type, row) {
                        if (data == 1) {
                            return '<span class="badge badge-success">SI</span>';
                        } else {
                            return '<span class="badge badge-danger">NO</span>';
                        }
                    }
                },
                {
                    data: 'action',
                    name: 'action',
                    orderable: false,
                    searchable: false,
                    width: '10%'
                }
            ],
            "language": {
                "info": "_TOTAL_ Sucursales",
                "search": "Buscar",
                "paginate": {
                    "next": "Siguiente",
                    "previous": "Anterior",
                },
                "lengthMenu": '_MENU_ Registros',
                "loadingRecords": "Cargando...",
                "processing": "Procesando...",
                "emptyTable": "SIN REGISTROS",
                "zeroRecords": "SIN REGISTROS",
                "infoEmpty": "",
                "infoFiltered": "",
            },
            fnDrawCallback: function (oSettings) {
                if (oSettings._iDisplayLength > oSettings.fnRecordsDisplay()) {
                    $(oSettings.nTableWrapper).find('.dataTables_paginate').hide();
                    $(oSettings.nTableWrapper).find('.dataTables_length').hide();
                }
            }
        });
    });

    $("#form_agrega_sucursal").validate({
        debug: false,
        event: "blur",
        errorElement: "label",

        rules: {
            sucursal: {
                required: true,
                minlength: 3,
                maxlength: 45
            },
            tipo: {
                required: true,
            },
            nombre: {
                required: true,
                minlength: 3,
                maxlength: 100
            },
            estado_suc: {
                required: true,
            }
        },
        messages: {
            sucursal: {
                required: "Ingresa una sucursal",
                minlength: "La sucursal debe tener al menos 3 caracteres",
                maxlength: "La sucursal debe tener como máximo 45 caracteres"
            },
            tipo: {
                required: "Selecciona un tipo de sucursal",
            },
            nombre: {
                required: "Ingresa un nombre",
                minlength: "El nombre debe tener al menos 3 caracteres",
                maxlength: "El nombre debe tener como máximo 100 caracteres"
            },
            estado_suc: {
                required: "Selecciona una opcion",
            }

        },

        submitHandler: function (form, e) {
            e.preventDefault();
            form.submit();
        }
    });


    $("#form_actualiza_sucursal").validate({
        debug: false,
        event: "blur",
        errorElement: "label",

        rules: {
            sucursal_edit: {
                required: true,
                minlength: 3,
                maxlength: 45
            },
            tipo_edit: {
                required: true,
            },
            nombre_edit: {
                required: true,
                minlength: 3,
                maxlength: 100
            },
            estado_suc_edit: {
                required: true,
            }
        },
        messages: {
            sucursal_edit: {
                required: "Ingresa una sucursal",
                minlength: "La sucursal debe tener al menos 3 caracteres",
                maxlength: "La sucursal debe tener como máximo 45 caracteres"
            },
            tipo_edit: {
                required: "Selecciona un tipo de sucursal",
            },
            nombre_edit: {
                required: "Ingresa un nombre",
                minlength: "El nombre debe tener al menos 3 caracteres",
                maxlength: "El nombre debe tener como máximo 100 caracteres"
            },
            estado_suc_edit: {
                required: "Selecciona una opcion",
            }

        },

        submitHandler: function (form, e) {
            e.preventDefault();
            form.submit();
        }
    });

    $(document).on("click", ".btn_actuliza_sucursal", function () {
        //Se recupera la ruta del boton
        const urlControlador = $(this).data("controller");

        //Se ejecuta el controlador por medio de ajax
        $.ajax({
            url: urlControlador,
            contentType: false,
            processData: false,

            beforeSend: function () {
                $("#form_actualiza_sucursal")[0].reset();
                $("#tipo_edit option:selected").removeAttr("selected");
                $("#estado_edit option:selected").removeAttr("selected")
            },
            success: function (data) {
                $('#id_sucursal_edit').val(data.data.id);
                $("#sucursal_edit").val(data.data.sucursal);
                $("#nombre_edit").val(data.data.nombre);
                $("#tipo_edit > option[value = '" + data.data.tipo + "']").attr("selected", true);
                $("#estado_suc_edit > option[value = '" + data.data.activa + "']").attr("selected", true);
            }
        });
    });
});
