@extends('layouts.dashboard.dashboard')
@section('title', 'Sucursales')

@section('content')
    <div class="container-dashboard">
        <!-- Pager Hedaer -->
        <div class="div-content-dashboard">

            <!-- breadcrumbs -->
            <nav class="flex py-3 text-gray-700" aria-label="Breadcrumb">
                <ol class="inline-flex items-center">
                    <li class="li-beadcrumbs">
                        <a href="{{ route('dashboard.inicio') }}" class="a-beadcrumbs-hover">
                            <i class="fa-solid fa-house mr-1 w-4 h-4"></i>
                            Inicio
                        </a>
                    </li>
                    <li class="li-beadcrumbs">
                        <i class="fa-solid fa-chevron-right i-beadcrumbs"></i>
                        <span class="a-beadcrumbs">Configuraciones</span>
                    </li>
                    <li class="li-beadcrumbs">
                        <i class="fa-solid fa-chevron-right i-beadcrumbs"></i>
                        <span class="a-beadcrumbs font-semibold">Sucursales</span>
                    </li>
                </ol>
            </nav>
            <!-- //breadcrumbs -->

            <!-- Content -->
            <div class="div-header-dashboard">
                <!-- header -->
                <div class="div-title-dashboard title-dashboard">
                    <a>Sucursales</a>
                </div>

                <div class="div-buttons-header-corte">
                    @can('configuraciones.sucursales.registra_sucursal')
                        <button type="button" data-modal="registra_sucursal" class="modal-open btn-primary-fit">
                            Agregar Sucursal
                        </button>
                    @endcan
                </div>
            </div>

            <div class="div-header-buttons-corte-resp">
                <div class="div-buttons-header-corte-resp">
                    @can('configuraciones.sucursales.registra_sucursal')
                        <button type="button" data-modal="registra_sucursal" class="modal-open btn-primary-full">
                            Agregar Sucursal
                        </button>
                    @endcan
                </div>
            </div>
            <!-- //header -->

            <div class="material-datatables mt-8">
                <table id="sucursales_table" class="stripe" cellspacing="0" width="100%" style="width:100%">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Sucursal</th>
                            <th>Nombre</th>
                            <th>Tipo</th>
                            <th>Activa</th>

                            <th class="disabled-sorting">Acciones</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
        @include('layouts.dashboard.partials.sucursales.modals')
    @endsection


    @section('scripts')
        <script src="{{ asset('js/configuraciones/sucursales.js') }}" defer></script>
    @endsection
