@extends('layouts.dashboard.dashboard')
@section('title', 'Dashboard')

@section('content')
    <div class="container-dashboard">
        <!-- Pager Hedaer -->
        <div class="div-content-dashboard">
            <!-- breadcrumbs -->
            <nav class="flex py-3 text-gray-700" aria-label="Breadcrumb">
                <ol class="inline-flex items-center space-x-1 md:space-x-3">
                    <li class="li-beadcrumbs">
                        <a href="{{ route('dashboard.inicio') }}" class="a-beadcrumbs-hover">
                            <i class="fa-solid fa-house mr-1 w-4 h-4"></i>
                            Inicio
                        </a>
                    </li>
                </ol>
            </nav>
            <!-- //breadcrumbs -->


            <div class="div-header-corte">
                <div class="div-saludo">
                    <div class="font-bold text-xl phone:text-base">
                        <span>{{ $saludo }}, </span>
                        <span>{{ Auth::user()->nombre }} {{ Auth::user()->ap_paterno }}
                            {{ Auth::user()->ap_materno }}</span>
                    </div>

                    <div class="flex flex-row text-gray-500 text-sm mt-[1%] phone:text-xs">
                        <div><a><i class="fa-solid fa-square-parking"></i> {{ $nombreSucursal }}</a></div>

                        @if (Auth::user()->sucursal_asignada == 'TODOS')
                            <div class="basis-8 grid grid-flow-col auto-cols-auto">
                                <button id="btn_cambia_sucursal" class="tooltip"
                                    data-tooltip-target="tooltip-sucursal"type="button">
                                    <i class="fa-solid fa-arrows-rotate"> </i>
                                </button>
                            </div>
                        @endif
                    </div>
                </div>
            </div>

            <!-- Cards caja -->
            <div id="div_cards_cajas"
                class="my-9 rounded-lg overflow-hidden shadow-lg bg-white border border-border-card-corte">

                <div class="div-content-card-dashboard">
                    <a class="font-bold text-lg phone:text-base">Resumen del turno</a>

                    <div class="flex h-fit mt-4 gap-9 justify-center items-center phone:flex-col">
                        @foreach ($terminales as $terminal)
                            <div class="card-fit">
                                <div class="icon-card">
                                    <i class="fa-solid fa-cash-register"></i>
                                </div>

                                <div class="content-card">
                                    <div class="title-card">
                                        <span>Venta total - {{ $terminal->terminal }}</span>
                                    </div>
                                    <div class="description-card">
                                        <a> ${{ $montos[$loop->index] }} </a>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
            <!-- //Cards caja -->

            <!-- gráficas -->
            <div id="div_cards_cajas"
                class="my-9 rounded-lg overflow-hidden shadow-lg bg-white border border-border-card-corte">

                <div class="div-content-card-dashboard">
                    <a class="font-bold text-lg phone:text-base">Resumen general</a>

                    <div class="flex h-fit mt-2 gap-2 justify-center items-center tablet:flex-col; phone:flex-col">
                        <div style="width: 100%; margin: 1em;" id="chart1"></div>
                        <div style="width: 100%; margin: 1em;" class="pt-5" id="chart2"></div>
                        <div style="width: 100%; margin: 1em;" class="pt-5" id="chart3"></div>
                    </div>
                </div>
            </div>
            <!-- //gráficas -->


            <div id="selecciona_sucursal" tabindex="-1" aria-hidden="true" data-modal="selecciona_sucursal"
                class="modal pointer-events-none opacity-0 ">
                <div class="backgroud-modal"></div>
                <div class="content-modal-33">

                    <div class="modal-content py-4 text-left px-6">
                        <div class="flex justify-between items-center pb-3 mb-6">
                            <p class="text-2xl font-bold">Seleccion de sucursal</p>
                        </div>

                        <form class="space-y-6" method="POST" id="form_selecciona_sucursal">
                            @csrf


                            <div id='div_select_empresas'>
                                <label for="empresas" class="label-form">Empresas</label>
                                <select id="empresas" name="empresas" class="select-form" required>
                                    <option value="">SELECCIONA UNA EMPRESA</option>
                                    @foreach ($empresas as $empresa)
                                        <option value="{{ $empresa->id }}">{{ $empresa->empresa }}
                                    @endforeach
                                </select>
                            </div>

                            <div id='div_select_sucursales'>
                                <label for="sucursal" class="label-form">Sucursales</label>
                                <select id="sucursal" name="sucursal" class="select-form" required>
                                    <option value="">SELECCIONA UNA SUCURSAL</option>

                                </select>
                            </div>
                    </div>

                    <!--Footer-->
                    <div class="footer-modal">
                        <button type="submit" class="btn-primary-fit-modal">Seleccionar</button>
                    </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
@endsection
