@extends('layouts.dashboard.dashboard')
@section('title', 'Registro de movimientos')

@section('content')
    <div class="container-dashboard">
        <!-- Pager Hedaer -->
        <div class="div-content-dashboard">

            <!-- breadcrumbs -->
            <nav class="flex py-3 text-gray-700" aria-label="Breadcrumb">
                <ol class="inline-flex items-center">

                    <li class="li-beadcrumbs">
                        <a href="{{ route('dashboard.inicio') }}" class="a-beadcrumbs-hover">
                            <i class="fa-solid fa-house mr-1 w-4 h-4"></i>
                            Inicio
                        </a>
                    </li>
                    <li class="li-beadcrumbs">
                        <i class="fa-solid fa-chevron-right i-beadcrumbs"></i>
                        <span class="a-beadcrumbs">Movimientos</span>
                    </li>
                    <li class="li-beadcrumbs">
                        <i class="fa-solid fa-chevron-right i-beadcrumbs"></i>
                        <span class="a-beadcrumbs font-semibold">Registro de movimientos</span>
                    </li>
                </ol>
            </nav>
            <!-- //breadcrumbs -->

            <div class="title-dashboard">
                <a>Registro de movimientos</a>
            </div>
            <!-- //Pager Hedaer -->

            <!-- Content -->
            <div id='div_tabs'
                class="tabs-movimientos text-base font-medium text-center text-gray-500 border-b border-div-border-tabs mt-10">
                <ul class="flex flex-wrap -mb-px">
                    <li class="mr-2">
                        <button class="tabs-active btn-tabs" id="ingresos-tab" data-tabs-target="#ingresos" type="button"
                            role="tab" aria-controls="ingresos" aria-selected="true">Entrada de antibiotico</button>
                    </li>
                    <li class="mr-2">
                        <button class="btn-tabs" id="retiros-tab" data-tabs-target="#retiros" type="button" role="tab"
                            aria-controls="retiros" aria-selected="false">Salida de antibiotico</button>
                    </li>
                </ul>
            </div>

            <div id='div_tabs_panels' class="mt-8">
                <div id="ingresos" class="tabs-panel" role="tabpanel" aria-labelledby="ingresos-tab">
                    <form method="POST" id="form_inicia_entrada">
                        <div class="div-header-corte px-5 py-5">
                            <div class="flex flex-row items-stretch gap-4">
                                <a class="font-bold text-2xl text-center">ENTRADA DE ANTIBIOTICO</a>

                                @csrf

                                @if (session('sucursalSession') == 'TODOS' || session('rolSession') != 'USUARIO')
                                    <div for="sku_entrada" id='div_sku_entrada' class='w-[45%]'>
                                        <label class="label-form">Codigo del producto</label>
                                        <input type="text" name="sku_entrada" id="sku_entrada" class="input-form"
                                            required>
                                        <label id="sku_entrada-error" class="error" for="sku_entrada"></label>
                                    </div>

                                    <div for="sucursal_entrada" id='div_sucursal_entrada' class="w-fit">
                                        <label class="label-form">Sucursal</label>
                                        <select id="sucursal_entrada" name="sucursal_entrada" class="select-form" required>
                                            @foreach ($listaSucursales as $sucursal)
                                                <option value="{{ $sucursal->sucursal }}">
                                                    {{ $sucursal->nombre }}
                                                </option>
                                            @endforeach
                                        </select>
                                        <label id="sucursal_entrada-error" class="error" for="sucursal_entrada"></label>
                                    </div>
                                @else
                                    <div for="sku_entrada" id='div_sku_entrada' class='w-[65%]'>
                                        <label class="label-form">Codigo del producto</label>
                                        <input type="text" name="sku_entrada" id="sku_entrada" class="input-form"
                                            required>
                                        <label id="sku_entrada-error" class="error" for="sku_entrada"></label>
                                    </div>
                                @endif



                                <div class="grid grid-cols-2 grid-flow-col justify-items-end self-end gap-x-3">
                                    <button type="button" id='btn_inicia_entrada' class="btn-primary-full">
                                        Iniciar
                                    </button>

                                    <button type="button" id="btn_limpia_entrada" disabled
                                        class="btn-primary-full">
                                        Limpiar
                                    </button>
                                </div>

                            </div>
                        </div>
                    </form>



                    <div id="form_entrada" class="div-header-corte px-5 py-5">
                        <form class="space-y-6" method="POST" id="form_registra_entrada">
                            @csrf

                            <a id="nombre_producto" class="font-bold text-xl text-center"></a>

                            <div class="grid grid-cols-3 gap-4 phone:grid-cols-2">

                                <div for="denominacionDistEntrada">
                                    <label for="denominacionDistEntrada" class="label-form">Denominación
                                        distintiva</label>
                                    <input type="text" name="denominacionDistEntrada" id="denominacionDistEntrada"
                                        class="input-form" required disabled>
                                </div>

                                <div for="denominacionGenEntrada">
                                    <label for="denominacionGenEntrada" class="label-form">Denominación genérica</label>
                                    <input type="text" name="denominacionGenEntrada" id="denominacionGenEntrada"
                                        class="input-form" required disabled>
                                </div>

                                <div for="presentacionEntrada">
                                    <label for="presentacionEntrada" class="label-form">Presentación</label>
                                    <input type="text" name="presentacionEntrada" id="presentacionEntrada"
                                        class="input-form" required disabled>
                                </div>

                                <div for="laboratorioEntrada">
                                    <label for="laboratorioEntrada" class="label-form">Laboratorio</label>
                                    <input type="text" name="laboratorioEntrada" id="laboratorioEntrada"
                                        class="input-form" required disabled>
                                </div>

                                <div for="procedenciaEntrada">
                                    <label for="procedenciaEntrada" class="label-form">Procedencia</label>
                                    <input type="text" name="procedenciaEntrada" id="procedenciaEntrada"
                                        class="input-form" required disabled>
                                </div>

                                <div for="domicilioEntrada">
                                    <label for="domicilioEntrada" class="label-form">Domicilio</label>
                                    <input type="text" name="domicilioEntrada" id="domicilioEntrada"
                                        class="input-form" required disabled>
                                </div>

                                <div for="numFacturaEntrada">
                                    <label for="numFacturaEntrada" class="label-form">Num. Factura</label>
                                    <input type="text" name="numFacturaEntrada" id="numFacturaEntrada"
                                        class="input-form" required disabled>
                                </div>


                                <div for="cantidadEntrada">
                                    <label for="cantidadEntrada" class="label-form">Cantidad adquirida</label>
                                    <input type="text" name="cantidadEntrada" id="cantidadEntrada" class="input-form"
                                        required disabled>
                                </div>

                                <div for="saldoEntrada">
                                    <label for="saldoEntrada" class="label-form">Saldo</label>
                                    <input type="text" name="saldoEntrada" id="saldoEntrada" class="input-form"
                                        required disabled>
                                </div>
                            </div>

                            <div for="observacionesEntrada" class="w-full">
                                <label for="observacionesEntrada" class="label-form">Observaciones</label>
                                <input type="text" name="observacionesEntrada" id="observacionesEntrada"
                                    class="input-form" disabled>
                            </div>

                            <button type="submit" id="btn_registra_entrada" class="btn-primary-full-movimientos"
                                disabled>Registrar</button>
                        </form>
                    </div>
                </div>

                <div id="retiros" class="hidden tabs-panel" role="tabpanel" aria-labelledby="retiros-tab">
                    <form method="POST" id="form_inicia_salida">
                        <div class="div-header-corte px-5 py-5">
                            <div class="flex flex-row items-stretch gap-4">

                                <a class="font-bold text-2xl text-center px-[1%]">SALIDA DE ANTIBIOTICO</a>

                                @csrf

                                @if (session('sucursalSession') == 'TODOS' || session('rolSession') != 'USUARIO')
                                    <div for="sku_salida" id="div_sku_salida" class="w-[45%]">
                                        <label class="label-form">Codigo del producto</label>
                                        <input type="text" name="sku_salida" id="sku_salida" class="input-form"
                                            required>
                                        <label id="sku_salida-error" class="error" for="sku_salida"></label>
                                    </div>

                                    <div for="sucursal_salida" id='div_sucursal_salida' class="w-fit">
                                        <label class="label-form">Sucursal</label>
                                        <select id="sucursal_salida" name="sucursal_salida" class="select-form" required>
                                            @foreach ($listaSucursales as $sucursal)
                                                <option value="{{ $sucursal->sucursal }}">
                                                    {{ $sucursal->nombre }}
                                                </option>
                                            @endforeach
                                        </select>
                                        <label id="sucursal_salida-error" class="error" for="sucursal_salida"></label>
                                    </div>
                                @else
                                    <div for="sku_salida" id="div_sku_salida" class="w-[65%]">
                                        <label class="label-form">Codigo del producto</label>
                                        <input type="text" name="sku_salida" id="sku_salida" class="input-form"
                                            required>
                                        <label id="sku_salida-error" class="error" for="sku_salida"></label>
                                    </div>
                                @endif

                                <div class="grid grid-cols-2 grid-flow-col justify-items-end self-end gap-x-3">
                                    <button type="button" id='btn_inicia_salida' class="btn-primary-full">
                                        Iniciar
                                    </button>

                                    <button type="button" id="btn_limpia_salida" disabled
                                        class="btn-primary-full">
                                        Limpiar
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>



                    <div id="form_salida" class="div-header-corte px-5 py-5">
                        <form class="space-y-6" method="POST" id="form_registra_salida">
                            @csrf

                            <a id="nombre_producto_salida" class="font-bold text-xl text-center"></a>

                            <div class="grid grid-cols-3 gap-4 phone:grid-cols-2">

                                <div for="denominacionDistSalida">
                                    <label for="denominacionDistSalida" class="label-form">Denominación
                                        distintiva</label>
                                    <input type="text" name="denominacionDistSalida" id="denominacionDistSalida"
                                        class="input-form" required disabled>
                                </div>

                                <div for="denominacionGenSalida">
                                    <label for="denominacionGenSalida" class="label-form">Denominación
                                        genérica</label>
                                    <input type="text" name="denominacionGenSalida" id="denominacionGenSalida"
                                        class="input-form" required disabled>
                                </div>

                                <div for="presentacionSalida">
                                    <label for="presentacionSalida" class="label-form">Presentación</label>
                                    <input type="text" name="presentacionSalida" id="presentacionSalida"
                                        class="input-form" required disabled>
                                </div>

                                <div for="laboratorioSalida">
                                    <label for="laboratorioSalida" class="label-form">Laboratorio</label>
                                    <input type="text" name="laboratorioSalida" id="laboratorioSalida"
                                        class="input-form" required disabled>
                                </div>

                                <div for="preescribeSalida">
                                    <label for="preescribeSalida" class="label-form">Nombre
                                        de quien preescribe</label>
                                    <input type="text" name="preescribeSalida" id="preescribeSalida"
                                        class="input-form" required disabled>
                                </div>

                                <div for="domicilioSalida">
                                    <label for="domicilioSalida" class="label-form">Domicilio</label>
                                    <input type="text" name="domicilioSalida" id="domicilioSalida" class="input-form"
                                        required disabled>
                                </div>

                                <div for="cedulaSalida">
                                    <label for="cedulaSalida" class="label-form">Cedula
                                        profesional</label>
                                    <input type="text" name="cedulaSalida" id="cedulaSalida" class="input-form"
                                        required disabled>
                                </div>

                                <div for="listaSurtidos" id='div_listaSurtidos' class="w-full">
                                    <label class="label-form">Tipo de surtido</label>
                                    <select id="listaSurtidos" name="listaSurtidos" class="select-form" required
                                        disabled>
                                        <option></option>
                                        <option id="total" value="total">SURTIDO TOTAL</option>
                                        <option id="parcial" value="parcial">SURTIDO PARCIAL</option>
                                    </select>
                                </div>


                                <div class="grid grid-cols-2 gap-4">
                                    <div for="cantidadSalida">
                                        <label for="cantidadSalida" class="label-form">Cantidad vendida</label>
                                        <input type="text" name="cantidadSalida" id="cantidadSalida"
                                            class="input-form" required disabled>
                                    </div>

                                    <div for="saldoSalida">
                                        <label for="saldoSalida" class="label-form">Saldo</label>
                                        <input type="text" name="saldoSalida" id="saldoSalida" class="input-form"
                                            required disabled>
                                    </div>
                                </div>
                            </div>

                            <div for="observacionesSalida" class="w-full">
                                <label for="observacionesSalida" class="label-form">Observaciones</label>
                                <input type="text" name="observacionesSalida" id="observacionesSalida"
                                    class="input-form" disabled>
                            </div>

                            <button type="submit" id="btn_registra_salida" class="btn-primary-full-movimientos"
                                disabled>Registrar</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @include('layouts.dashboard.partials.movimientos.registros.modals')
@endsection


@section('scripts')
    <script src="{{ asset('js/movimientos/entradas.js') }}" defer></script>
    <script src="{{ asset('js/movimientos/salidas.js') }}" defer></script>
@endsection
