@extends('layouts.dashboard.dashboard')
@section('title', 'Reporte de movimientos')

@section('content')
    <div class="container-dashboard max-w-[98%]">
        <!-- Pager Hedaer -->
        <div class="div-content-dashboard">

            <!-- breadcrumbs -->
            <nav class="flex py-3 text-gray-700" aria-label="Breadcrumb">
                <ol class="inline-flex items-center">

                    <li class="li-beadcrumbs">
                        <a href="{{ route('dashboard.inicio') }}" class="a-beadcrumbs-hover">
                            <i class="fa-solid fa-house mr-1 w-4 h-4"></i>
                            Inicio
                        </a>
                    </li>
                    <li class="li-beadcrumbs">
                        <i class="fa-solid fa-chevron-right i-beadcrumbs"></i>
                        <span class="a-beadcrumbs">Reportes</span>
                    </li>
                    <li class="li-beadcrumbs">
                        <i class="fa-solid fa-chevron-right i-beadcrumbs"></i>
                        <span class="a-beadcrumbs font-semibold">Reporte de movimientos</span>
                    </li>
                </ol>
            </nav>
            <!-- //breadcrumbs -->

            <div class="title-dashboard">
                <a>Reporte de movimientos</a>
            </div>
            <!-- //Pager Hedaer -->

            <form method="POST" id="form_inicia_busqueda">
                <div class="div-header-corte px-5 py-5">
                    <div class="flex flex-row items-stretch gap-4">
                        @csrf

                        <div for="input_busqueda">
                            <label for="input_busqueda" class="label-form" class='w-[30%]'>Codigo del producto, producto,
                                denominación, numero de factura y receta</label>
                            <input type="text" name="input_busqueda" id="input_busqueda" class="input-form" required>
                            <label id="input_busqueda-error" class="error" for="input_busqueda"></label>
                        </div>

                        <div for="fecha_inicio" id='div_fecha_inicio' class='w-[10%]'>
                            <label class="label-form">Fecha inicio</label>
                            <input type="date" name="fecha_inicio" id="fecha_inicio" class="input-form" required>
                            <label id="fecha_inicio-error" class="error" for="fecha_inicio"></label>
                        </div>

                        <div for="fecha_fin" id='div_fecha_fin' class='w-[10%]'>
                            <label class="label-form">Fecha final</label>
                            <input type="date" name="fecha_fin" id="fecha_fin" class="input-form" required>
                            <label id="fecha_fin-error" class="error" for="fecha_fin"></label>
                        </div>

                        <div for="sucursal" id='div_sucursal' class="w-[15%]">
                            <label class="label-form">Sucursal</label>
                            <select id="sucursal" name="sucursal" class="select-form" required>
                                @foreach ($listaSucursales as $sucursal)
                                    <option value="{{ $sucursal->sucursal }}" data-nombre="{{ $sucursal->nombre }}">
                                        {{ $sucursal->nombre }}
                                    </option>
                                @endforeach
                            </select>
                            <label id="sucursal-error" class="error" for="sucursal"></label>
                        </div>

                        <div class="grid grid-cols-4 grid-flow-col justify-items-end self-end gap-x-3">
                            <button type="button" id='btn_busca_movimientos' class="btn-primary-full">
                                Buscar
                            </button>

                            <button type="button" id="btn_limpia_movimientos" disabled
                                class="btn-primary-full">
                                Limpiar
                            </button>

                            <button type="button" id="btn_exporta" disabled class="btn-primary-full">
                                Excel
                            </button>

                            <button type="button" id="btn_imprime" disabled class="btn-primary-full">
                                PDF
                            </button>
                        </div>

                    </div>
                </div>
            </form>

            <div class="div-header-corte px-5 py-5">
                <div class="material-datatables text-[13px]">

                    <div class="subTitle-dashboard mb-10 text-center">
                        <a>Entradas al libro de antibiotico</a>
                    </div>

                    <table id="tablaRegistrosEntradas" class="stripe" cellspacing="0" width="100%">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Fecha</th>
                                <th>Codigo</th>
                                <th>Producto</th>
                                <th>Denominación distintiva</th>
                                <th>Denominación genérica</th>
                                <th>Presentación</th>
                                <th>Procedencia</th>
                                <th>Domicilio</th>
                                <th>Número de factura</th>
                                <th>Cantidad adquirida</th>
                                <th>Saldo</th>
                                <th>Observaciones</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>

            <div class="div-header-corte px-5 py-5">
                <div class="material-datatables text-[13px]">

                    <div class="subTitle-dashboard mb-10 text-center">
                        <a>Salidas del libro de antibiotico</a>
                    </div>

                    <table id="tablaRegistrosSalidas" class="stripe" cellspacing="0" width="100%">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Fecha</th>
                                <th>Codigo</th>
                                <th>Producto</th>
                                <th>Denominación distintiva</th>
                                <th>Denominación genérica</th>
                                <th>Presentación</th>
                                <th>Nombre de quien Prescribe</th>
                                <th>Domicilio</th>
                                <th>Cedula profesional</th>
                                <th>Número receta</th>
                                <th>Cantidad vendida</th>
                                <th>Saldo</th>
                                <th>Observaciones</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>


            <!-- Content -->
        </div>
    </div>

    @include('layouts.dashboard.partials.reportes.movimientos.modals')
@endsection


@section('scripts')
    <script src="{{ asset('js/reportes/movimientos.js') }}" defer></script>
@endsection
