<!doctype html>
<html>

<head>
    <meta charset="utf-8">
    <style>
        body {
            font-family: 'Arial', sans-serif;
        }

        .border-black {
            border-color: #000000;
        }

        .border-solid {
            border-style: solid;
        }

        .border-2 {
            border-width: 2px;
        }

        .w-full {
            width: 100%;
        }

        .w-48 {
            width: 192px;
        }

        .p-5 {
            padding: 20px;
        }

        .pl-5 {
            padding-left: 20px;
        }

        .pb-5 {
            padding-bottom: 20px;
        }

        .text-xs {
            font-size: 0.75rem;
            line-height: 1rem;
        }

        .text-left {
            text-align: left !important;
        }

        .text-center {
            text-align: center;
        }

        .border-collapse {
            border-collapse: collapse !important;
        }

        .border {
            border: 1px solid #000 !important;
        }
    </style>
</head>

<body>
    <div class="border-black border-solid border-2 w-full">
        <table>

            <!-- Colocacion del logo del reporte, y el titulo dependiendo el tipo de sucursal -->
            <tr>
                <td> <img style="height: 60px; margin: 20px;" src="images/reportes/logo.jpg" /> </td>
                <th style="padding-top: 20px;">
                    <h4>{{ $titulo }}</h4>
                </th>
            </tr>


            <!-- Fechas en las que se realiza la busqueda de datos -->
            <tr>
                <th class="pl-5 text-xs text-left">
                    <span>Fecha inicio: {{ $fechaInicial }}</span>
                </th>
            </tr>
            <tr>
                <th class="pl-5 pb-5 text-xs text-left">
                    <span>Fecha fin: {{ $fechaFinal }} </span>
                </th>
            </tr>
        </table>
    </div>

    <br>

    <table border="1" style="width: 115mm; border-collapse: collapse !important; border: 1px solid #000 !important;" cellspacing="0">
        <colgroup>
            <col style="width: 3%"> <!-- Número de registro -->
            <col style="width: 8%"> <!-- Fecha -->
            <col style="width: 15%"> <!-- Código de producto -->
            <col style="width: 35%"> <!-- Producto -->
            <col style="width: 12%"> <!-- DENOMINACIÓN DISTINTIVA -->
            <col style="width: 23%"> <!-- DENOMINACIÓN GENÉRICA -->
            <col style="width: 12%"> <!-- PRESENTACIÓN -->
            <col style="width: 12%"> <!-- LABORATORIO -->
            <col style="width: 13%"> <!-- PROCEDENCIA -->
            <col style="width: 11%"> <!-- NOMBRE DE QUIEN PRESCRIBE -->
            <col style="width: 25%"> <!-- DOMICILIO -->
            <col style="width: 10%"> <!-- CEDULA PROFESIONAL -->
            <col style="width: 7%"> <!-- NÚMERO DE FACTURA -->
            <col style="width: 7%"> <!-- NÚMERO DE RECETA -->
            <col style="width: 7.5%"> <!-- CANTIDAD ADQUIRIDA -->
            <col style="width: 7%"> <!-- CANTIDAD VENDIDA-->
            <col style="width: 5%"> <!-- SALDO -->
            <col style="width: 20%"> <!-- OBSERVACIONES -->
        </colgroup>
        <tr style="font-size: 6px;">
            <th style="text-align:center">#</th>
            <th style="text-align:center">FECHA</th>
            <th style="text-align:center">CODIGO</th>
            <th style="text-align:center">PRODUCTO</th>
            <th style="text-align:center">DENOMINACIÓN DISTINTIVA</th>
            <th style="text-align:center">DENOMINACIÓN GENÉRICA</th>
            <th style="text-align:center">PRESENTACIÓN</th>
            <th style="text-align:center">LABORATORIO</th>
            <th style="text-align:center">PROCEDENCIA</th>
            <th style="text-align:center">NOMBRE DE QUIEN PRESCRIBE</th>
            <th style="text-align:center">DOMICILIO</th>
            <th style="text-align:center">CEDULA PROFESIONAL</th>
            <th style="text-align:center">NÚMERO DE FACTURA</th>
            <th style="text-align:center">NÚMERO DE RECETA</th>
            <th style="text-align:center">CANTIDAD ADQUIRIDA</th>
            <th style="text-align:center">CANTIDAD VENDIDA</th>
            <th style="text-align:center">SALDO</th>
            <th style="text-align:center">OBSERVACIONES</th>
        </tr>

        @foreach ($data as $key => $dataRegistro)
            <tr style="font-size: 6px;" class="text-center">
                <td style="border: 1px solid #000 !important;">{{ $dataRegistro['id'] }}</td>
                <td style="border: 1px solid #000 !important;">{{ $dataRegistro['fecha'] }}</td>
                <td style="border: 1px solid #000 !important;">{{ $dataRegistro['codigo_producto'] }}</td>
                <td style="border: 1px solid #000 !important;">{{ $dataRegistro['producto'] }}</td>
                <td style="border: 1px solid #000 !important;">{{ $dataRegistro['denominacion_dist'] }}</td>
                <td style="border: 1px solid #000 !important;">{{ $dataRegistro['denominacion_gen'] }}</td>
                <td style="border: 1px solid #000 !important;">{{ $dataRegistro['presentacion'] }}</td>
                <td style="border: 1px solid #000 !important;">{{ $dataRegistro['laboratorio'] }}</td>
                <td style="border: 1px solid #000 !important;">{{ $dataRegistro['procedencia'] }}</td>
                <td style="border: 1px solid #000 !important;">{{ $dataRegistro['nombre_pree'] }}</td>
                <td style="border: 1px solid #000 !important;">{{ $dataRegistro['domicilio'] }}</td>
                <td style="border: 1px solid #000 !important;">{{ $dataRegistro['cedula'] }}</td>
                <td style="border: 1px solid #000 !important;">{{ $dataRegistro['factura'] }}</td>
                <td style="border: 1px solid #000 !important;">{{ $dataRegistro['receta'] }} </td>
                <td style="border: 1px solid #000 !important;">{{ $dataRegistro['cantidad_adquirida'] }} </td>
                <td style="border: 1px solid #000 !important;">{{ $dataRegistro['cantidad_vendida'] }} </td>
                <td style="border: 1px solid #000 !important;">{{ $dataRegistro['saldo'] }} </td>
                <td style="border: 1px solid #000 !important;">{{ $dataRegistro['observaciones'] }}</td>
            </tr>
        @endforeach
    </table>
</body>

</html>
