<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>@yield('title')|Libro de antibiotico</title>

    <!-- Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:ital@0;1&display=swap" rel="stylesheet">

    <!-- JQUERY -->
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js" integrity="sha384-DfXdz2htPH0lsSSs5nCTpuj/zy4C+OGpamoFVy38MVBnE+IbbVYUew+OrCXaRkfj" crossorigin="anonymous"></script>

    <!-- AJAX -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.0.0/jquery.min.js"></script>

    <!-- JQUERY VALIDATE -->
    <script src="https://cdn.jsdelivr.net/npm/jquery-validation@1.19.5/dist/jquery.validate.js"></script>

    <!-- DATATABLE -->
    <script src="https://cdn.datatables.net/1.12.1/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.3.0/js/dataTables.responsive.min.js"></script>

    <script src="https://kit.fontawesome.com/1be469e467.js" crossorigin="anonymous"></script>

    <!-- Styles -->
    @notifyCss

    <link href="{{ asset('css/app.css') }}" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="{{ asset('css/print.css') }}">

    <!-- DATA TABLE -->
    <link rel="stylesheet" href="//cdn.datatables.net/1.12.1/css/jquery.dataTables.min.css">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/responsive/2.3.0/css/responsive.dataTables.min.css"/>

</head>

<body class="font-poppins bg-body-dashboard">
    @include('layouts.dashboard.partials.siderbarMenu')

    <div id="app">
        <main>
            @include('layouts.dashboard.partials.header')

            @yield('content')
        </main>
    </div>

    <x:notify-messages />

    <!-- Scripts -->
    @routes
    @notifyJs
    <script src="{{ asset('js/app.js') }}" defer></script>
    <script src="{{ asset('js/jquery.numeric.js') }}" module></script>
    @yield('scripts')


</body>
</html>
