<nav x-data="{ open: false }" @keydown.window.escape="open = false" class="bg-gray-800 py-2">
    <div class="px-8 lg:px-10">
        <div class="flex items-center justify-between h-16">
            <button class="btn-drawer-menu" type="button" data-drawer-target="drawer-navigation"
                data-drawer-show="drawer-navigation" aria-controls="drawer-navigation" data-expanded="close">
                <svg class="w-5 h-5" stroke="currentColor" fill="none" viewBox="0 0 24 24">
                    <path :class="{ 'hidden': open, 'inline-flex': !open }" class="inline-flex" stroke-linecap="round"
                        stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                </svg>
            </button>

            <div class="flex items-center justify-between !important">
                <div class="flex-shrink-0">
                    <h1 class="text-lg font-semibold tracking-widest text-white uppercase">
                        <a href="#" class="flex items-center">
                        </a>
                    </h1>
                </div>
            </div>



            <!-- Usuario -->
            <div class="hidden lg:block">
                <div class="flex items-center ml-4 md:ml-6">
                    <div @click.away="open = false" class="relative ml-3" x-data="{ open: false }">
                        <div>
                            <button @click="open = !open"
                                class="flex items-center max-w-xs text-sm text-white rounded-full focus:outline-none focus:shadow-solid"
                                id="user-menu" aria-label="User menu" aria-haspopup="true" x-bind:aria-expanded="open">
                                <i class="fa-regular fa-circle-user text-3xl"></i>


                                <div class="ml-3">
                                    <div class="text-base font-medium leading-none text-white">
                                        {{ Auth::user()->nombre }}
                                        {{ Auth::user()->ap_paterno }} {{ Auth::user()->ap_materno }}</div>
                                    <div class="mt-1 text-sm font-medium leading-none text-gray-400">
                                        {{ Auth::user()->privilegio }}</div>
                                </div>
                            </button>
                        </div>
                        <div x-show="open" class="drown-menu-nav" x-transition:enter="transition ease-out duration-100"
                            x-transition:enter-start="transform opaity-0 scale-95"
                            x-transition:enter-end="transform opacity-100 scale-100"
                            x-transition:leave="transition ease-in duration-75"
                            x-transition:leave-start="transform opacity-100 scale-100"
                            x-transition:leave-end="transform opacity-0 scale-95">

                            <div class="py-1 bg-white rounded-md shadow-xs">
                                <a href="{{ route('logout') }}"
                                    onclick="event.preventDefault(); document.getElementById('logout-form').submit();"
                                    class="flex flex-row items-center px-4 py-2 text-sm text-red-500 hover:text-red-700 hover:bg-red-100 focus:outline-none focus:text-red-700 focus:bg-red-100">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" viewBox="0 0 24 24"
                                        fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                        stroke-linejoin="round" class="feather feather-log-out">
                                        <path d="M9 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h4"></path>
                                        <polyline points="16 17 21 12 16 7"></polyline>
                                        <line x1="21" y1="12" x2="9" y2="12"></line>
                                    </svg>
                                    <span class="ml-2">Cerrar sesion</span>
                                </a>
                                <form id="logout-form" action="{{ route('logout') }}" method="POST" class="hidden">
                                    {{ csrf_field() }}
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
</nav>

<nav class="px-2 bg-red-800 h-[15px]"></nav>
